package com.agilex.healthcare.veteranappointment.domain;

import com.agilex.healthcare.utility.datemarshallers.DateTimeMarshaller;
import com.agilex.healthcare.veteranappointment.serializer.JsonDateSerializer;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

import javax.xml.bind.annotation.*;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Serializable;
import java.util.Date;


@XmlRootElement(namespace = Namespace.VeteranAppointmentRequest, name = "feedback")
@XmlAccessorType(value = XmlAccessType.NONE)
@XmlType(namespace = Namespace.VeteranAppointmentRequest)
public class VARFeedback implements Serializable{
	private static final long serialVersionUID = 1459951628489298815L;

	public VARFeedback() {
	}

	@XmlElement
	private String uniqueId;

	@JsonSerialize(using = JsonDateSerializer.class)
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "MM/dd/yyyy HH:mm:ss")
	@XmlElement
	@XmlJavaTypeAdapter(DateTimeMarshaller.class)
	private Date dateCreated;

	@XmlElement
	private String type;
	
	@XmlElement
	private Integer recommendationRating; 
	
	@XmlElement
	private String comments;

	public String getComments() {
		return comments;
	}

	public void setComments(String comments) {
		this.comments = comments;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public Integer getRecommendationRating() {
		return recommendationRating;
	}

	public void setRecommendationRating(Integer recommendationRating) {
		this.recommendationRating = recommendationRating;
	}

	public Date getDateCreated() {
		return dateCreated;
	}

	public void setDateCreated(Date dateCreated) {
		this.dateCreated = dateCreated;
	}

	public String getUniqueId() {
		return uniqueId;
	}

	public void setUniqueId(String uniqueId) {
		this.uniqueId = uniqueId;
	}
}
